import os
# import timer
import run_bayesian_network

def read_excuted_tasks(filename):
    """Reads completed task numbers from the file."""
    completed_tasks = set()
    if os.path.exists(filename):
        with open(filename, 'r') as file:
            for line in file:
                completed_tasks.add((line.strip()))
    return completed_tasks

def write_excuted_task(filename, task_number):
    """Writes a task number to the file indicating it has been excuted."""
    with open(filename, 'a') as file:
        file.write(f"{task_number}\n")

def main():
    data_type = 'C'
    n_ls = [15, 20, 25]
    N_ls = [5000, 20000]
    d_ls = [0.5, 1, 1.5, 2]

    if not os.path.exists('count.txt'):
        with open('count.txt', 'w') as file:
            file.write('')
    count_file = 'count.txt'

    for n in n_ls:
        for N in N_ls:
            for d in d_ls:
                for data_index in range(10):
                    if str((n, N, d, data_index)) not in read_excuted_tasks(count_file):
                        write_excuted_task(count_file, str((n, N, d, data_index)))
                        print(f"Running Task {(n, N, d, data_index)}")
                        run_bayesian_network.run(data_type, n, N, d, data_index) # assume this is your k-th task

if __name__ == "__main__":
    main()